/*
 * Decompiled with CFR 0.152.
 */
package Game_Engine.GUI.Components.small;

import BryceMath.Calculations.Colors;
import BryceMath.Geometry.Rectangle;
import Game_Engine.GUI.Components.communication.gui_hoverText;
import Game_Engine.GUI.Components.small.gui_label;
import Game_Engine.GUI.Interfaces.Pingable;
import Game_Engine.GUI.Sprites.StyleSpec;
import java.awt.Color;

public class gui_button
extends gui_label
implements Pingable {
    private boolean flag;
    private boolean clickedOn = false;
    private boolean glow;
    private int glowPhase = 0;
    private Color glowOn = Color.gray;
    private Color glowOff = Color.white;
    private int glowSpeed = 10;
    private Color C_clickedOn = Colors.C_GRAY3;
    private static gui_hoverText INFO_LABEL = new gui_hoverText(0.0, 0.0, 128, 32);
    private String myInfoText = null;

    public gui_button(double x, double y, int w, int h) {
        super(x, y, w, h);
        this.iVars();
    }

    public gui_button(Rectangle r) {
        super(r);
        this.iVars();
    }

    private void iVars() {
        this.setRestingColor(StyleSpec.C_BUTTON_UP);
        this.setDrawBorders(true);
    }

    @Override
    public void update() {
        super.update();
        if (this.mouseInRegion && this.myInfoText != null && INFO_LABEL.getOBj() != this) {
            INFO_LABEL.setObj(this, this.myInfoText);
        }
        if ((this.mouseInRegion || this.highlighted) && this.isEnabled()) {
            if (this.clickedOn) {
                this.setColor(this.C_clickedOn);
            } else {
                this.setColor(this.Color_mouse_in_region());
            }
        } else if (this.isGlowing()) {
            this.glowPhase += this.glowSpeed;
            this.glowPhase %= 360;
            double glowOnPercentage = 0.5 + 0.5 * Math.sin(Math.toRadians(this.glowPhase));
            this.setColor(Colors.weightedAverageColor(this.glowOn, this.glowOff, glowOnPercentage));
        } else {
            this.revertColor();
        }
    }

    @Override
    public void mouseP(int mx, int my) {
        if (!this.isEnabled() || !this.mouse_left()) {
            return;
        }
        this.clickedOn = true;
    }

    @Override
    public void mouseR(int a, int b) {
        if (this.clickedOn) {
            this.flag = true;
        }
    }

    @Override
    public void global_mouseR() {
        this.clickedOn = false;
    }

    @Override
    public boolean flag() {
        if (this.flag) {
            this.flag = false;
            return true;
        }
        return false;
    }

    @Override
    public void setFlag(boolean input) {
        this.flag = input;
    }

    public void setGlow(boolean glow) {
        this.glow = glow;
    }

    public void flash() {
        this.glow = true;
    }

    public boolean isGlowing() {
        return this.glow;
    }

    public void flash(int speed) {
        this.glow = true;
        this.glowSpeed = speed;
    }

    @Override
    public void disable() {
        super.disable();
        this.setGlow(false);
    }

    @Override
    public void setVisible(boolean flag) {
        super.setVisible(flag);
        if (!flag) {
            this.setGlow(false);
        }
    }

    protected Color Color_mouse_in_region() {
        return StyleSpec.C_BUTTON_DOWN;
    }

    public void INFO(String str) {
        this.myInfoText = str;
    }
}

